<?php

require_once dirname(__FILE__) . '/PaymentGatewayFactory.php';
include("../include/routeros_api.php");
include("../include/koneksi.php");

/**
 * Get provider from invoice/order_id
 */
function getProviderFromInvoice($order_id, $koneksi)
{
  // First, try to get provider from tb_tagihan based on order_id
  $stmt = $koneksi->prepare("SELECT provider FROM tb_tagihan WHERE order_id = ? LIMIT 1");
  $stmt->bind_param("s", $order_id);
  $stmt->execute();
  $result = $stmt->get_result();
  $invoice = $result->fetch_assoc();

  if ($invoice && !empty($invoice['provider'])) {
    return $invoice['provider'];
  }

  // Fallback: detect from URL if invoice doesn't have provider
  $request_uri = $_SERVER['REQUEST_URI'] ?? '';

  if (strpos($request_uri, '/midtrans') !== false || strpos($request_uri, 'midtrans') !== false) {
    return 'midtrans';
  }

  if (strpos($request_uri, '/tripay') !== false || strpos($request_uri, 'tripay') !== false) {
    return 'tripay';
  }

  if (strpos($request_uri, '/xendit') !== false || strpos($request_uri, 'xendit') !== false) {
    return 'xendit';
  }

  // Check URL parameters as fallback
  if (isset($_GET['provider'])) {
    return strtolower($_GET['provider']);
  }

  return null;
}

// Get order_id from different provider formats
$order_id = null;
$input = json_decode(file_get_contents('php://input'), true);

// Try to extract order_id from different sources
if (isset($_POST['order_id'])) {
  $order_id = $_POST['order_id']; // Midtrans
} elseif (isset($input['order_id'])) {
  $order_id = $input['order_id']; // Generic
} elseif (isset($input['merchant_ref'])) {
  $order_id = $input['merchant_ref']; // Tripay
} elseif (isset($input['external_id'])) {
  $order_id = $input['external_id']; // Xendit
}

if (!$order_id) {
  http_response_code(400);
  echo "Order ID not found in notification";
  exit;
}

// Get provider from invoice
$provider = getProviderFromInvoice($order_id, $koneksi);

if (!$provider) {
  http_response_code(400);
  echo "Unable to detect payment provider for order: " . $order_id;
  exit;
}

// Get payment gateway configuration for detected provider
$queryP = $koneksi->query("SELECT * FROM tbl_pgate WHERE provider = '$provider' LIMIT 1");
$tokenP = $queryP->fetch_assoc();

if (!$tokenP) {
  // Fallback to any available provider config
  $queryP = $koneksi->query("SELECT * FROM tbl_pgate LIMIT 1");
  $tokenP = $queryP->fetch_assoc();

  if (!$tokenP) {
    http_response_code(400);
    echo "Payment gateway not configured";
    exit;
  }
}

try {
  // Create payment gateway instance
  $paymentGateway = PaymentGatewayFactory::create($provider, $tokenP);

  // Handle notification based on provider
  if ($provider === 'midtrans') {
    $notificationData = $paymentGateway->handleNotification($_POST);
  } else {
    // For Tripay and Xendit, typically use raw input
    $input = json_decode(file_get_contents('php://input'), true);
    $notificationData = $paymentGateway->handleNotification($input ?: $_POST);
  }
} catch (\Exception $e) {
  http_response_code(400);
  echo "Notification processing error: " . $e->getMessage();
  exit;
}

$transaction = $notificationData['transaction_status'];
$type = $notificationData['payment_type'];
$order_id = $notificationData['order_id'];
$fraud = $notificationData['fraud_status'];

// Normalize transaction status across different providers
function normalizeTransactionStatus($status, $provider)
{
  $status = strtoupper($status);

  switch ($provider) {
    case 'tripay':
      switch ($status) {
        case 'PAID':
          return 'settlement';
        case 'UNPAID':
          return 'pending';
        case 'EXPIRED':
          return 'expire';
        case 'FAILED':
          return 'deny';
        case 'REFUND':
          return 'cancel';
        default:
          return strtolower($status);
      }

    case 'xendit':
      switch ($status) {
        case 'PAID':
          return 'settlement';
        case 'SETTLED':
          return 'settlement';
        case 'PENDING':
          return 'pending';
        case 'EXPIRED':
          return 'expire';
        case 'FAILED':
          return 'deny';
        case 'CANCELLED':
          return 'cancel';
        default:
          return strtolower($status);
      }

    case 'midtrans':
    default:
      // Midtrans already uses the standard format
      return strtolower($status);
  }
}

// Normalize the transaction status
$transaction = normalizeTransactionStatus($transaction, $provider);


if ($transaction == 'capture') {
  // For credit card transaction, we need to check whether transaction is challenge by FDS or not
  if ($type == 'credit_card') {
    if ($fraud == 'challenge') {
      // TODO set payment status in merchant's database to 'Challenge by FDS'
      // TODO merchant should decide whether this transaction is authorized or not in MAP
      echo "Transaction order_id: " . $order_id . " is challenged by FDS";
    } else {
      // TODO set payment status in merchant's database to 'Success'
      echo "Transaction order_id: " . $order_id . " successfully captured using " . $type;
    }
  }
} else if ($transaction == 'settlement') {
  $bulan = date('m');
  $tgl2 = date('Y');
  $sql = $koneksi->query("SELECT id_tagihan,order_id FROM tb_tagihan WHERE order_id = '$order_id'");
  $data = $sql->fetch_assoc();
  $no_spt = $data['order_id'];

  // $urut = substr($no_spt, 0, 5);
  // $tambah = (int) $urut + 1;
  // if (strlen($tambah) == 1) {
  //   $format = "0000" . $tambah . ".BLR.MST.";
  // } else if (strlen($tambah) == 2) {
  //   $format = "000" . $tambah . ".BLR.MST.";
  // } else if (strlen($tambah) == 3) {
  //   $format = "00" . $tambah . ".BLR.MST.";
  // } else if (strlen($tambah) == 4) {
  //   $format = "0" . $tambah . ".BLR.MST.";
  // } else {
  //   $format = $tambah . ".BLR.MST.";
  // }

  // $pieces = explode("-", $order_id);
  $id_tagihan = $data['id_tagihan'];

  $tgl_bayar = date('Y-m-d');

  $sql_tagihan = $koneksi->query("SELECT * FROM tb_tagihan, tb_pelanggan, tb_paket, tb_user WHERE tb_pelanggan.id_pelanggan=tb_tagihan.id_pelanggan AND tb_pelanggan.id_pelanggan=tb_user.id_pelanggan AND tb_paket.id_paket=tb_pelanggan.paket AND tb_tagihan.id_tagihan='$id_tagihan'");
  $data_tagihan = $sql_tagihan->fetch_assoc();

  if (!$data_tagihan) {
    http_response_code(403); // Atau: header("HTTP/1.1 404 Not Found");
    echo json_encode([
      "success" => false,
      "status" => 404,
      "message" => "Data tagihan tidak ditemukan."
    ]);
    exit;
  }

  $sql_mikrotik = $koneksi->query("SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1");
  $row = $sql_mikrotik->fetch_assoc();

  $id_pelanggan = $data_tagihan['id_pelanggan'];
  $jatuh_tempo = $data_tagihan['jatuh_tempo'];
  $jml_bayar = $data_tagihan['jml_bayar'];
  $pelanggan = $data_tagihan['nama_pelanggan'];
  $paket = $data_tagihan['nama_paket'];
  // $ip_address = $data_tagihan['ip_address'];
  $no_telp = $data_tagihan['no_telp'];
  $sekarangs = date('d F Y H:i:s');
  $ket = "Pembayaran Internet AN." . "&nbsp" . $pelanggan . "," . "&nbsp" . "Paket" . "&nbsp" . $paket;
  $tgl_pemasangan_obj = new \DateTime($jatuh_tempo);
  $jam_sekarang = date('H:i:s'); // Mendapatkan jam saat ini
  $tanggal_sekarang = date('Y-m-d'); // Mendapatkan tanggal saat ini
  // Jika tanggal pembayaran lebih kecil dari tanggal jatuh tempo, tambahkan 1 bulan ke tanggal jatuh tempo
  if ($tanggal_sekarang < $jatuh_tempo) {
    $tgl_pemasangan_obj->modify('+1 Month');
  }

  $conPelanggan = $koneksi->query("SELECT * FROM tbl_penggunamikrotik");
  $checkUser = $conPelanggan->fetch_assoc();

  if (($checkUser['status'] == 'ya') || ($checkUser['ippelanggan'] == 'dynamic')) {
    $ip_address = $data_tagihan['username'];
  } else {
    $ip_address = $data_tagihan['ip_address'];
  }

  if (!empty($row)) {
    $API = new \RouterosAPI();
    if ($API->connect($row['ip'], $row['username'], $row['password'])) {

      if ($checkUser['ippelanggan'] == 'statik') {
        $xIpa = filter_var($ip_address, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4);
        if (!$xIpa) {
          $sql_pelanggan = "SELECT * FROM tb_user WHERE username = '$ip_address'";
          $result_pelanggan = mysqli_query($koneksi, $sql_pelanggan);
          while ($row_pelanggan = mysqli_fetch_assoc($result_pelanggan)) {
            $id = $row_pelanggan['id_pelanggan']; // Ambil nama pelanggan
            $sql_pelanggan_ip = $koneksi->query("SELECT * FROM tb_pelanggan WHERE id_pelanggan = '$id'");
            while ($row_up = $sql_pelanggan_ip->fetch_assoc()) {
              $ip_address = $row_up['ip_address'];
              $sql_pelanggan = $koneksi->query("SELECT * FROM tb_pelanggan WHERE ip_address = '$ip_address'");
            }
          }
        } else {
          $ip_address = mysqli_real_escape_string($koneksi, $ip_address);
          $sql_pelanggan = $koneksi->query("SELECT * FROM tb_pelanggan WHERE ip_address = '$ip_address'");
        }
        //var_dump($ip_address);exit(0);
        while ($row_pelanggan = $sql_pelanggan->fetch_assoc()) {

          $ip_pelanggan = $row_pelanggan['ip_address'];

          $commentToSearch = "Blokir Bulanan " . $ip_pelanggan;

          $API->write('/ip/firewall/address-list/print', false);
          $API->write('?comment=' . $commentToSearch);

          $ips = $API->read();

          if (!empty($ips)) {
            // Proses entri address-list yang ditemukan
            foreach ($ips as $ip_data) {
              // Hapus entri address-list berdasarkan ID yang ditemukan
              $API->write('/ip/firewall/address-list/remove', false);
              $API->write('=.id=' . $ip_data['.id']);
              $API->read();
              echo "Berhasil menghapus entri address-list dengan komentar: " . $ip_data['comment'] . "<br>";
            }
          } else {
            echo "Tidak ada entri address-list yang ditemukan.";
          }
        }
      } else {
        $sql_pelanggan = "SELECT * FROM tb_user WHERE username = '$ip_address'";
        $result_pelanggan = mysqli_query($koneksi, $sql_pelanggan);

        while ($row_pelanggan = mysqli_fetch_assoc($result_pelanggan)) {
          $username = $row_pelanggan['username']; // Ambil nama pelanggan

          // Menonaktifkan PPP Secret
          $API->comm("/ppp/secret/enable", array(
            "numbers" => $username,
          ));
        }
      }
    }
  }
  $tgl_jatuh_tempo = $tgl_pemasangan_obj->format('Y-m-d') . ' ' . $jam_sekarang;
  $sql2 = $koneksi->query("UPDATE tb_tagihan SET terbayar='$jml_bayar', status_bayar=1, tgl_bayar='$tgl_bayar', blokir_status=NULL, order_id='$order_id', waktu_bayar=NOW(), user_id=NULL WHERE id_tagihan='$id_tagihan'");
  $sql_test = $koneksi->query("UPDATE tb_pelanggan SET jatuh_tempo='$tgl_jatuh_tempo' WHERE id_pelanggan='$id_pelanggan'");
  $query3 = $koneksi->query("INSERT INTO tb_kas (tgl_kas, keterangan, penerimaan, id_tagihan)VALUES('$tgl_bayar', '$ket', '$jml_bayar', '$id_tagihan') ");

  $sql_token = $koneksi->query("SELECT * FROM tbl_token WHERE id_token = 1");
  $row = $sql_token->fetch_assoc();

  if (!empty($row)) {
    $authorizationToken = $row['token'];

    $sql_notifbayar = $koneksi->query("SELECT * FROM tbl_notifbayar");
    $bayar = $sql_notifbayar->fetch_assoc();

    if (!empty($bayar)) {
      $pesanBayar = $bayar['pesan_bayar'];
      $pesanBayar = str_replace('$nama', $pelanggan, $pesanBayar);
      $formatJmlByr = 'Rp. ' . number_format($jml_bayar, 0, ',', '.');
      $pesanBayar = str_replace('$tagihan', $formatJmlByr, $pesanBayar);
      $pesanBayar = str_replace('$harinin', $sekarangs, $pesanBayar);
      $pesanBayar = str_replace('$no_telp', $no_telp, $pesanBayar);

      $curl = curl_init();

      curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.fonnte.com/send',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => array(
          'target' => $no_telp,
          'message' => $pesanBayar,
          'countryCode' => '62', //optional
        ),
        CURLOPT_HTTPHEADER => array(
          'Authorization: ' . $authorizationToken //change TOKEN to your actual token
        ),
      ));

      $response = curl_exec($curl);

      curl_close($curl);
      echo $response;
    } else {
    }
  } else {
  }
} else if ($transaction == 'pending') {
  // Update payment status to pending
  $pieces = explode("-", $order_id);
  $id_tagihan = $pieces[0];
  echo "Waiting customer to finish transaction order_id: " . $order_id . " using " . $type;
} else if ($transaction == 'deny') {
  // Update payment status to failed
  $pieces = explode("-", $order_id);
  $id_tagihan = $pieces[0];
  echo "Payment using " . $type . " for transaction order_id: " . $order_id . " is denied.";
} else if ($transaction == 'expire') {
  // Update payment status to expired
  $pieces = explode("-", $order_id);
  $id_tagihan = $pieces[0];
  echo "Payment using " . $type . " for transaction order_id: " . $order_id . " is expired.";
} else if ($transaction == 'cancel') {
  // Update payment status to failed
  $pieces = explode("-", $order_id);
  $id_tagihan = $pieces[0];
  echo "Payment using " . $type . " for transaction order_id: " . $order_id . " is canceled.";
}

// Response with success for webhook acknowledgment
http_response_code(200);
echo "OK";
