<?php

include("../include/koneksi.php");

// Include constants if not already defined
if (!defined('APP_ENV')) {
  if (file_exists('../constants.php')) {
    require_once '../constants.php';
  } else {
    define('APP_ENV', 'development'); // Default fallback
  }
}

session_start();

if (!isset($_SESSION['user'])) {
  header("Location: login.php");
  exit();
}

if (!isset($_POST['id_tagihan']) || !isset($_POST['nama_pelanggan'])) {
  die("Error: Data Tidak Ditemukan.");
}

$id_tagihan = $_POST['id_tagihan'];
$nama_pelanggan = $_POST['nama_pelanggan'];

$sql = $koneksi->query("SELECT * FROM tb_tagihan 
                       INNER JOIN tb_pelanggan ON tb_tagihan.id_pelanggan = tb_pelanggan.id_pelanggan 
                       INNER JOIN tb_paket ON tb_pelanggan.paket = tb_paket.id_paket
                       INNER JOIN tb_user ON tb_pelanggan.id_pelanggan = tb_user.id_pelanggan
                       WHERE tb_tagihan.id_tagihan = '$id_tagihan'
                       AND tb_pelanggan.nama_pelanggan = '$nama_pelanggan'");

if (!$sql) {
  die("Query failed: " . $koneksi->error);
}

if ($sql->num_rows == 0) {
  die("Error: Data Tidak Ditemukan.");
}

$payment = $sql->fetch_assoc();

$sqll = $koneksi->query("SELECT * FROM tbl_badmin WHERE id_badmin=1");
$bAdmin = $sqll->fetch_assoc();

$conPelanggan = $koneksi->query("SELECT * FROM tbl_penggunamikrotik");
$checkUser = $conPelanggan->fetch_assoc();

if ($checkUser['ippelanggan'] == 'statik') {
  $ip = $payment['ip_address'];
} else {
  $ip = $payment['username'];
}

// Get payment gateway configuration
$queryPgate = $koneksi->query("SELECT * FROM tbl_pgate LIMIT 1");
$pgateConfig = $queryPgate->fetch_assoc();
$currentProvider = $pgateConfig['provider'] ?? 'midtrans';

// Function to get Tripay payment channels from API
function getTripayPaymentChannels($config)
{
  $apiKey = $config['tclientkey'];
  $isProduction = (defined('APP_ENV') && APP_ENV === 'production');

  // Simple caching - cache for 1 hour
  $cacheFile = '../tmp/tripay_channels_cache.json';
  $cacheTime = 3600; // 1 hour

  // Check if cache exists and is still valid
  if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    $cachedData = file_get_contents($cacheFile);
    $decoded = json_decode($cachedData, true);
    if ($decoded && is_array($decoded)) {
      return $decoded;
    }
  }

  $url = $isProduction ? 'https://tripay.co.id/api/merchant/payment-channel' : 'https://tripay.co.id/api-sandbox/merchant/payment-channel';

  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HEADER => false,
    CURLOPT_HTTPHEADER => [
      'Authorization: Bearer ' . $apiKey,
      'Content-Type: application/json'
    ],
    CURLOPT_FAILONERROR => true,
    CURLOPT_TIMEOUT => 10,
    CURLOPT_CONNECTTIMEOUT => 5,
  ]);

  $response = curl_exec($curl);
  $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
  $error = curl_error($curl);
  curl_close($curl);

  if ($httpCode == 200 && $response && !$error) {
    $data = json_decode($response, true);
    if ($data && $data['success'] && isset($data['data'])) {
      // Save to cache
      if (!is_dir('../tmp')) {
        mkdir('../tmp', 0755, true);
      }
      file_put_contents($cacheFile, json_encode($data['data']));
      return $data['data'];
    }
  }

  // Log error for debugging
  if ($error) {
    error_log("Tripay API Error: " . $error);
  }

  // Fallback to default channels if API fails
  return [
    [
      'code' => 'BRIVA',
      'name' => 'BRI Virtual Account',
      'group' => 'Virtual Account',
      'total_fee' => ['flat' => 4000],
      'active' => true,
      'minimum_amount' => 10000,
      'maximum_amount' => 10000000
    ],
    [
      'code' => 'BNIVA',
      'name' => 'BNI Virtual Account',
      'group' => 'Virtual Account',
      'total_fee' => ['flat' => 4000],
      'active' => true,
      'minimum_amount' => 10000,
      'maximum_amount' => 10000000
    ],
    [
      'code' => 'BCAVA',
      'name' => 'BCA Virtual Account',
      'group' => 'Virtual Account',
      'total_fee' => ['flat' => 5500],
      'active' => true,
      'minimum_amount' => 10000,
      'maximum_amount' => 10000000
    ],
    [
      'code' => 'QRIS',
      'name' => 'QRIS',
      'group' => 'E-Wallet',
      'total_fee' => ['flat' => 750],
      'active' => true,
      'minimum_amount' => 1000,
      'maximum_amount' => 5000000
    ]
  ];
}

// Function to get icon based on payment group and code
function getPaymentIcon($group, $code)
{
  $iconMap = [
    'Virtual Account' => 'fa-university',
    'Convenience Store' => 'fa-store',
    'E-Wallet' => 'fa-mobile-alt',
    'QRIS' => 'fa-qrcode'
  ];

  if ($code === 'QRIS') {
    return 'fa-qrcode';
  }

  return $iconMap[$group] ?? 'fa-credit-card';
}

// Get Tripay payment channels if provider is Tripay
$tripayChannels = [];
if ($currentProvider === 'tripay') {
  $tripayChannelsData = getTripayPaymentChannels($pgateConfig);

  // Process and format channels
  foreach ($tripayChannelsData as $channel) {
    if ($channel['active']) {
      $tripayChannels[] = [
        'code' => $channel['code'],
        'name' => $channel['name'],
        'group' => $channel['group'],
        'fee' => $channel['total_fee']['flat'],
        'icon' => getPaymentIcon($channel['group'], $channel['code']),
        'minimum_amount' => $channel['minimum_amount'] ?? 0,
        'maximum_amount' => $channel['maximum_amount'] ?? 0
      ];
    }
  }
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Detail Pembayaran</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <style>
    body {
      font-family: 'Arial', sans-serif;
      background-color: #f4f4f4;
      margin: 0;
      padding: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
    }

    .payment-container {
      background-color: #fff;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      overflow: hidden;
      width: 90%;
      max-width: 400px;
      margin: auto;
      margin-top: 20px;
    }

    .payment-header {
      background-color: #007bff;
      color: #fff;
      padding: 5px;
      text-align: center;
    }

    .payment-content {
      padding: 20px;
      text-align: center;
    }

    .info-item {
      margin-bottom: 15px;
      text-align: left;
    }

    .info-item strong {
      display: block;
      margin-bottom: 5px;
    }

    select {
      width: 100%;
      padding: 8px;
      margin-bottom: 15px;
    }

    button {
      background-color: #007bff;
      color: #fff;
      padding: 10px 20px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      width: 45%;
      margin-right: 5%;
      margin-bottom: 10px;
    }

    button:hover {
      background-color: #0056b3;
    }

    .payment-method-container {
      margin: 20px 0;
      padding: 15px;
      border: 1px solid #ddd;
      border-radius: 8px;
      background-color: #f9f9f9;
    }

    .payment-method-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 10px;
      margin-top: 15px;
    }

    .payment-method-option {
      border: 2px solid #ddd;
      border-radius: 8px;
      padding: 15px;
      cursor: pointer;
      transition: all 0.3s ease;
      background-color: white;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .payment-method-option:hover {
      border-color: #007bff;
      background-color: #f0f8ff;
    }

    .payment-method-option.selected {
      border-color: #007bff;
      background-color: #e7f3ff;
    }

    .payment-method-info {
      display: flex;
      align-items: center;
      flex: 1;
    }

    .payment-method-icon {
      font-size: 24px;
      margin-right: 12px;
      color: #007bff;
      width: 30px;
      text-align: center;
    }

    .payment-method-details h4 {
      margin: 0 0 5px 0;
      font-size: 14px;
      color: #333;
    }

    .payment-method-details p {
      margin: 0;
      font-size: 12px;
      color: #666;
    }

    .payment-method-group {
      font-size: 11px;
      color: #888;
      font-style: italic;
    }

    .payment-method-fee {
      font-weight: bold;
      color: #28a745;
      font-size: 12px;
    }

    .payment-method-radio {
      margin-left: 10px;
    }

    #tripay-methods {
      display: none;
    }

    .method-selector-header {
      font-weight: bold;
      margin-bottom: 10px;
      color: #333;
    }
  </style>
</head>

<body>
  <div class="payment-container">
    <div class="payment-header">
      <h3>Detail Pembayaran</h3>
    </div>
    <div class="payment-content">
      Lakukan Pembayaran Otomatis
      <hr>
      <form action="metode-pembayaran.php" method="POST" id="payment-form">
        <div class="info-item">
          <input type="hidden" name="id_tagihan" value="<?= $payment['id_tagihan'] ?>">
          <input type="hidden" name="ip" value="<?= $ip ?>">
          <strong>Nama</strong> <?= $payment['nama_pelanggan'] ?>
          <input type="hidden" name="name_user" value="<?= $payment['nama_pelanggan'] ?>">
          <input type="hidden" name="nama_paket" value="<?= $payment['nama_paket'] ?>">
          <input type="hidden" name="no_telp" value="<?= $payment['no_telp'] ?>">
          <hr>
        </div>
        <div class="info-item">
          <strong>Paket</strong> <?= $payment['nama_paket'] ?>
          <input type="hidden" name="name_paket" value="<?= $payment['nama_paket'] ?>">
          <hr>
        </div>
        <div class="info-item">
          <?php
          $bulanTahun = $payment['bulan_tahun'];
          $bulan = substr($bulanTahun, 0, 2);
          $tahun = substr($bulanTahun, 2);
          $formattedDate = $bulan . ' - ' . $tahun;
          ?>
          <strong>Pembayaran Bulan</strong> <?= $formattedDate ?>
          <hr>
        </div>
        <?php if (!empty($bAdmin['harga'] && $bAdmin['status'] == 'pelanggan')) { ?>
          <div class="info-item">
            <?php
            $g = $bAdmin['harga'];
            $hargaAdmin = number_format($g, 0, ',', '.');
            ?>
            <strong>Biaya Admin</strong> Rp.<?= $hargaAdmin ?>
            <hr>
          </div>
        <?php } ?>
        <div class="info-item">
          <?php

          $getData = $koneksi->query("SELECT * FROM tbl_paketmikrotik");
          $data1 = $getData->fetch_assoc();

          if ($data1['ppn'] == 'aktif') {
            $ppn = $payment['harga'] * $payment['ppn'];
            $totalSemua = $payment['harga'] + $ppn + $g;

            $formattedTotalTagihan = 'Rp ' . number_format($totalSemua, 0, ',', '.');
          } else {
            $totalSemua = $payment['harga'] + $g;
            $formattedTotalTagihan = 'Rp ' . number_format($totalSemua, 0, ',', '.');
          }
          ?>
          <strong>Total Tagihan</strong> <?= $formattedTotalTagihan ?>
          <input type="hidden" name="harga" value="<?= $totalSemua ?>">
        </div>

        <?php if ($currentProvider === 'tripay' && !empty($tripayChannels)): ?>
          <!-- Tripay Payment Method Selection -->
          <div class="payment-method-container" id="tripay-methods">
            <div class="method-selector-header">
              <i class="fa fa-credit-card"></i> Pilih Metode Pembayaran Tripay:
              <small style="float: right; color: #888; font-size: 10px;">
                <?= count($tripayChannels) ?> metode tersedia
              </small>
            </div>
            <div class="payment-method-grid">
              <?php foreach ($tripayChannels as $channel): ?>
                <div class="payment-method-option" onclick="selectPaymentMethod('<?= $channel['code'] ?>')">
                  <div class="payment-method-info">
                    <i class="fa <?= $channel['icon'] ?> payment-method-icon"></i>
                    <div class="payment-method-details">
                      <h4><?= $channel['name'] ?></h4>
                      <p class="payment-method-group"><?= $channel['group'] ?></p>
                      <p class="payment-method-fee">
                        <?= $channel['fee'] > 0 ? 'Biaya: Rp ' . number_format($channel['fee'], 0, ',', '.') : 'Gratis' ?>
                      </p>
                    </div>
                  </div>
                  <input type="radio" name="payment_channel" value="<?= $channel['code'] ?>" class="payment-method-radio" required>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endif; ?>

        <hr>
        <button id="pay-button" type="submit">
          <?= ($currentProvider == 'tripay') ? 'Lanjutkan Pembayaran' : 'Metode Pembayaran' ?>
        </button>
      </form>
    </div>
  </div>
  <script>
    function goBack() {
      window.history.back();
    }

    function selectPaymentMethod(code) {
      // Remove selected class from all options
      document.querySelectorAll('.payment-method-option').forEach(option => {
        option.classList.remove('selected');
      });

      // Add selected class to clicked option
      event.currentTarget.classList.add('selected');

      // Check the radio button
      document.querySelector(`input[value="${code}"]`).checked = true;
    }

    // Show Tripay methods if provider is Tripay
    document.addEventListener('DOMContentLoaded', function() {
      const provider = '<?= $currentProvider ?>';
      if (provider === 'tripay') {
        document.getElementById('tripay-methods').style.display = 'block';
      }

      // Form validation for Tripay
      document.getElementById('payment-form').addEventListener('submit', function(e) {
        if (provider === 'tripay') {
          const selectedMethod = document.querySelector('input[name="payment_channel"]:checked');
          if (!selectedMethod) {
            e.preventDefault();
            alert('Silakan pilih metode pembayaran terlebih dahulu!');
            return false;
          }
        }
      });
    });
  </script>
</body>

</html>