<?php
session_start();

// Check authentication
if (!isset($_SESSION['admin']) && $_SESSION['teknisi'] != true) {
  die('Unauthorized access');
}

// Check if we have generated users in session
if (!isset($_SESSION['generated_users']) || empty($_SESSION['generated_users'])) {
  die('No users data found');
}

$generated_users = $_SESSION['generated_users'];

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="generated_users_' . date('Y-m-d_H-i-s') . '.csv"');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Expires: 0');

// Open output stream
$output = fopen('php://output', 'w');

// Write CSV headers
fputcsv($output, [
  'Username',
  'Password',
  'Profile',
  'Server',
  'Time Limit',
  'Data Limit',
  'Comment'
]);

// Write user data
foreach ($generated_users as $user) {
  fputcsv($output, [
    $user['username'],
    $user['password'],
    $user['profile'],
    $user['server'],
    $user['time_limit'] ?: 'Unlimited',
    $user['data_limit'] ?: 'Unlimited',
    $user['comment']
  ]);
}

// Close output stream
fclose($output);

// Clear the session data after export
unset($_SESSION['generated_users']);
exit;
