<?php
session_start();

// Check authentication
if (!isset($_SESSION['admin']) && $_SESSION['teknisi'] != true) {
  http_response_code(403);
  echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
  exit;
}

// Include database connection and RouterOS API
require_once '../../../include/koneksi.php';
require_once '../../../include/routeros_api.php';

// Check if username is provided
if (!isset($_POST['username']) || empty($_POST['username'])) {
  echo json_encode(['success' => false, 'message' => 'Username is required']);
  exit;
}

$username = $_POST['username'];

try {
  // Get MikroTik connection details
  $sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
  $result = mysqli_query($koneksi, $sql_mikrotik);
  $row = mysqli_fetch_assoc($result);

  $API = new RouterosAPI();

  if ($API->connect($row['ip'], $row['username'], $row['password'])) {

    // Find the user first
    $user_found = $API->comm("/ip/hotspot/user/print", [
      '?name' => $username
    ]);
    if (!empty($user_found)) {
      // Delete the user
      $delete_result = $API->comm("/ip/hotspot/user/remove", array(
        ".id" => $user_found[0]['.id']
      ));

      // Check if deletion was successful
      if (empty($delete_result) || !isset($delete_result[0]['!trap'])) {
        echo json_encode([
          'success' => true,
          'message' => "User '$username' has been deleted successfully!"
        ]);
      } else {
        echo json_encode([
          'success' => false,
          'message' => "Failed to delete user: " . ($delete_result[0]['=message'] ?? 'Unknown error')
        ]);
      }
    } else {
      echo json_encode([
        'success' => false,
        'message' => "User '$username' not found!"
      ]);
    }

    $API->disconnect();
  } else {
    echo json_encode([
      'success' => false,
      'message' => 'Failed to connect to MikroTik router!'
    ]);
  }
} catch (Exception $e) {
  echo json_encode([
    'success' => false,
    'message' => 'Error: ' . $e->getMessage()
  ]);
}
