<?php
session_start();
require_once '../../include/koneksi.php';

if (!isset($_SESSION['admin']) && !isset($_SESSION['teknisi'])) {
  exit('Unauthorized');
}

if (!isset($_GET['username'])) {
  exit('Username required');
}

$username = $_GET['username'];

// Get active template
$template_query = "SELECT * FROM tbl_hotspot_templates WHERE is_active = 1 LIMIT 1";
$template_result = mysqli_query($koneksi, $template_query);
$template = mysqli_fetch_assoc($template_result);

if (!$template) {
  exit('No active template found');
}

// Get MikroTik connection details
$sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
$result = mysqli_query($koneksi, $sql_mikrotik);
$mikrotik_config = mysqli_fetch_assoc($result);

// Get user data from MikroTik
require_once '../../include/routeros_api.php';
$API = new RouterosAPI();

$user_data = null;
if ($API->connect($mikrotik_config['ip'], $mikrotik_config['username'], $mikrotik_config['password'])) {
  $API->write("/ip/hotspot/user/print", false);
  $API->write("?name=$username");
  $users = $API->read();

  if (!empty($users)) {
    $user_data = $users[0];
  }

  $API->disconnect();
}

if (!$user_data) {
  exit('User not found');
}

// Prepare template variables
$variables = [
  '{{COMPANY_NAME}}' => 'L-ONE NETWORK', // You can make this configurable
  '{{COMPANY_PHONE}}' => '+62-XXX-XXX-XXXX', // You can make this configurable  
  '{{COMPANY_WEBSITE}}' => 'www.l-one.network', // You can make this configurable
  '{{USER_NAME}}' => $user_data['name'] ?? $username,
  '{{USERNAME}}' => $username,
  '{{PASSWORD}}' => $user_data['password'] ?? '',
  '{{USER_PROFILE}}' => $user_data['profile'] ?? '',
  '{{COMMENT}}' => $user_data['comment'] ?? '',
  '{{CREATED_DATE}}' => date('Y-m-d H:i:s'),
  '{{CURRENT_DATE}}' => date('Y-m-d'),
  '{{CURRENT_TIME}}' => date('H:i:s'),
  '{{LIMIT_BYTES}}' => formatBytes($user_data['limit-bytes-total'] ?? 0),
  '{{LIMIT_UPTIME}}' => formatUptime($user_data['limit-uptime'] ?? '0'),
  '{{SERVER_NAME}}' => $user_data['server'] ?? 'hotspot1'
];

// Replace variables in template
$html_content = $template['template_content'];
foreach ($variables as $variable => $value) {
  $html_content = str_replace($variable, $value, $html_content);
}

// Helper functions
function formatBytes($bytes)
{
  if ($bytes == 0) return 'Unlimited';

  $units = ['B', 'KB', 'MB', 'GB', 'TB'];
  $bytes = max($bytes, 0);
  $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
  $pow = min($pow, count($units) - 1);

  $bytes /= (1 << (10 * $pow));

  return round($bytes, 2) . ' ' . $units[$pow];
}

function formatUptime($uptime)
{
  if (empty($uptime) || $uptime == '0') return 'Unlimited';

  // Parse uptime format like "1d 2h 30m 45s" or just seconds
  if (is_numeric($uptime)) {
    $seconds = intval($uptime);
  } else {
    // Parse string format
    preg_match_all('/(\d+)([dhms])/', $uptime, $matches);
    $seconds = 0;
    for ($i = 0; $i < count($matches[1]); $i++) {
      $value = intval($matches[1][$i]);
      $unit = $matches[2][$i];
      switch ($unit) {
        case 'd':
          $seconds += $value * 86400;
          break;
        case 'h':
          $seconds += $value * 3600;
          break;
        case 'm':
          $seconds += $value * 60;
          break;
        case 's':
          $seconds += $value;
          break;
      }
    }
  }

  if ($seconds <= 0) return 'Unlimited';

  $days = floor($seconds / 86400);
  $hours = floor(($seconds % 86400) / 3600);
  $minutes = floor(($seconds % 3600) / 60);

  $result = '';
  if ($days > 0) $result .= $days . 'd ';
  if ($hours > 0) $result .= $hours . 'h ';
  if ($minutes > 0) $result .= $minutes . 'm';

  return trim($result) ?: '0m';
}

// Output the HTML
header('Content-Type: text/html; charset=utf-8');
echo $html_content;
