<?php
session_start();

// Include database connection
include '../../include/koneksi.php';

// Get usernames from URL parameter
$usernames_json = $_GET['usernames'] ?? '[]';
$usernames = json_decode($usernames_json, true);

if (empty($usernames) || !is_array($usernames)) {
  die('No users specified for printing');
}

// Get active template
$sql_template = "SELECT * FROM tbl_hotspot_templates WHERE is_active = 1 ORDER BY id DESC LIMIT 1";
$result_template = mysqli_query($koneksi, $sql_template);

if (!$result_template || mysqli_num_rows($result_template) == 0) {
  die('No active hotspot template found. Please create and activate a template first.');
}

$template = mysqli_fetch_assoc($result_template);

// Connect to MikroTik to get user details
$sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
$result_mikrotik = mysqli_query($koneksi, $sql_mikrotik);
$mikrotik = mysqli_fetch_assoc($result_mikrotik);

require_once '../../include/routeros_api.php';
$API = new RouterosAPI();

$users_data = [];

if ($API->connect($mikrotik['ip'], $mikrotik['username'], $mikrotik['password'])) {
  foreach ($usernames as $username) {
    // Get user details from MikroTik
    $API->write("/ip/hotspot/user/print", false);
    $API->write("?name=" . $username);
    $user_details = $API->read();

    if (!empty($user_details)) {
      $user = $user_details[0];
      $users_data[] = [
        'username' => $user['name'] ?? $username,
        'password' => $user['password'] ?? '',
        'profile' => $user['profile'] ?? '',
        'server' => $user['server'] ?? 'all',
        'comment' => $user['comment'] ?? '',
        'limit_uptime' => $user['limit-uptime'] ?? '',
        'limit_bytes' => $user['limit-bytes-total'] ?? ''
      ];
    } else {
      // If user not found in MikroTik, add basic info
      $users_data[] = [
        'username' => $username,
        'password' => 'N/A',
        'profile' => 'N/A',
        'server' => 'all',
        'comment' => '',
        'limit_uptime' => '',
        'limit_bytes' => ''
      ];
    }
  }
  $API->disconnect();
}

// Get the layout template
$layout_file = __DIR__ . '/layout.php';
if (!file_exists($layout_file)) {
  die('Layout file not found: ' . $layout_file);
}

// Function to replace template variables
function replaceTemplateVariables($template_content, $user_data)
{
  $variables = [
    // Standard RouterOS API variables
    '{{username}}' => $user_data['username'],
    '{{password}}' => $user_data['password'],
    '{{profile}}' => $user_data['profile'],
    '{{server}}' => $user_data['server'],
    '{{comment}}' => $user_data['comment'],
    '{{time_limit}}' => $user_data['limit_uptime'] ?: 'Unlimited',
    '{{data_limit}}' => $user_data['limit_bytes'] ?: 'Unlimited',

    // Extended template variables (case variations)
    '{{USERNAME}}' => $user_data['username'],
    '{{PASSWORD}}' => $user_data['password'],
    '{{USER_NAME}}' => $user_data['username'],
    '{{USER_PROFILE}}' => $user_data['profile'],
    '{{LIMIT_UPTIME}}' => $user_data['limit_uptime'] ?: 'Unlimited',
    '{{LIMIT_BYTES}}' => $user_data['limit_bytes'] ?: 'Unlimited',

    // Date and time variables
    '{{current_date}}' => date('Y-m-d'),
    '{{current_time}}' => date('H:i:s'),
    '{{CREATED_DATE}}' => date('Y-m-d H:i:s'),
    '{{CURRENT_DATE}}' => date('Y-m-d'),
    '{{CURRENT_TIME}}' => date('H:i:s'),

    // Company information (configurable)
    '{{company_name}}' => 'L-ONE NETWORK',
    '{{company_address}}' => 'Your Company Address Here',
    '{{company_phone}}' => 'Your Phone Number Here',
    '{{company_website}}' => 'www.your-website.com',
    '{{COMPANY_NAME}}' => 'L-ONE NETWORK',
    '{{COMPANY_ADDRESS}}' => 'Your Company Address Here',
    '{{COMPANY_PHONE}}' => 'Your Phone Number Here',
    '{{COMPANY_WEBSITE}}' => 'www.your-website.com'
  ];

  return str_replace(array_keys($variables), array_values($variables), $template_content);
}

// Render all tickets in the layout
ob_start();

// Configure grid layout: 4 columns per row
$tickets_per_row = 4;
$rows_per_page = 3; // Increase rows per page for better utilization
$tickets_per_page = $tickets_per_row * $rows_per_page;

// Generate template content for all users in grid format
$all_tickets_content = '';
$current_row_count = 0;
$current_page_tickets = 0;

// Start first page
$all_tickets_content .= '<div class="ticket-page">';

for ($i = 0; $i < count($users_data); $i++) {
  $user = $users_data[$i];

  // Start new row every 4 tickets
  if ($current_row_count === 0) {
    $all_tickets_content .= '<div class="ticket-row">';
  }

  $ticket_content = replaceTemplateVariables($template['template_content'], $user);

  // Add each ticket in a grid cell with exact 25% width for 4 columns
  $all_tickets_content .= '<div class="ticket-cell">' . $ticket_content . '</div>';

  $current_row_count++;
  $current_page_tickets++;

  // Close row when we have 4 tickets
  if ($current_row_count === $tickets_per_row) {
    $all_tickets_content .= '</div>'; // Close ticket-row
    $current_row_count = 0;
  }

  // Start new page when current page is full
  if ($current_page_tickets === $tickets_per_page && $i < count($users_data) - 1) {
    // Close any incomplete row
    if ($current_row_count > 0) {
      // Fill remaining cells in the row with empty cells
      for ($j = $current_row_count; $j < $tickets_per_row; $j++) {
        $all_tickets_content .= '<div class="ticket-cell empty-cell"></div>';
      }
      $all_tickets_content .= '</div>'; // Close incomplete row
      $current_row_count = 0;
    }
    $all_tickets_content .= '</div>'; // Close current page
    $all_tickets_content .= '<div class="ticket-page">'; // Start new page
    $current_page_tickets = 0;
  }
}

// Close any incomplete row by filling with empty cells
if ($current_row_count > 0) {
  // Fill remaining cells in the row with empty cells
  for ($j = $current_row_count; $j < $tickets_per_row; $j++) {
    $all_tickets_content .= '<div class="ticket-cell empty-cell"></div>';
  }
  $all_tickets_content .= '</div>'; // Close last row
}

// Close the last page
$all_tickets_content .= '</div>'; // Close last page

// Get the layout content
$layout_content = file_get_contents($layout_file);

// Replace the template placeholder with our generated content
$rendered_content = str_replace(
  ['<!-- Render Template Here -->', '<!-- End Render Template Here -->'],
  [$all_tickets_content, ''],
  $layout_content
);

// Output the final result
echo $rendered_content;
