-- Migration: Add provider column to tb_tagihan table
-- Date: 2025-08-27
-- Description: Add provider column to track which payment gateway was used for each invoice
-- Add provider column to tb_tagihan table
ALTER TABLE `tb_tagihan`
ADD COLUMN `provider` VARCHAR(50) NULL DEFAULT NULL COMMENT 'Payment gateway provider (midtrans, tripay, xendit, etc.)' AFTER `user_id`;

ALTER TABLE `tb_tagihan`
ADD COLUMN `order_id` VARCHAR(100) NULL DEFAULT NULL COMMENT 'Order ID from payment gateway' AFTER `provider`;

-- Add index for better performance when querying by provider
CREATE INDEX `idx_provider` ON `tb_tagihan` (`provider`);

-- Update existing records to set default provider (optional)
-- You can uncomment and modify this based on your current default provider
-- UPDATE `tb_tagihan` SET `provider` = 'midtrans' WHERE `provider` IS NULL;
-- Example queries to test the new column:
-- SELECT * FROM tb_tagihan WHERE provider = 'midtrans';
-- SELECT provider, COUNT(*) as total FROM tb_tagihan GROUP BY provider;