-- Migration: Add hotspot templates table
-- Created: <?= date('Y-m-d H:i:s') ?>
CREATE TABLE
  IF NOT EXISTS `tbl_hotspot_templates` (
    `id` int (11) NOT NULL AUTO_INCREMENT,
    `template_name` varchar(100) NOT NULL,
    `template_content` longtext NOT NULL,
    `is_active` tinyint (1) NOT NULL DEFAULT 0,
    `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4;

-- Insert default template
INSERT INTO
  `tbl_hotspot_templates` (`template_name`, `template_content`, `is_active`)
VALUES
  (
    'Default Template',
    '<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Hotspot User Ticket</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
            background: white;
        }
        .ticket {
            width: 350px;
            margin: 0 auto;
            border: 2px solid #333;
            padding: 15px;
            background: #f9f9f9;
        }
        .header {
            text-align: center;
            border-bottom: 1px solid #333;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        .logo {
            max-width: 80px;
            margin-bottom: 5px;
        }
        .company-name {
            font-size: 16px;
            font-weight: bold;
            margin: 5px 0;
        }
        .title {
            font-size: 14px;
            font-weight: bold;
            margin: 10px 0;
        }
        .user-info {
            margin: 15px 0;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin: 5px 0;
            border-bottom: 1px dotted #ccc;
            padding-bottom: 3px;
        }
        .label {
            font-weight: bold;
        }
        .credentials {
            background: #e8f4fd;
            padding: 10px;
            margin: 15px 0;
            border: 1px solid #b8daff;
            text-align: center;
        }
        .username, .password {
            font-size: 14px;
            font-weight: bold;
            margin: 5px 0;
        }
        .footer {
            text-align: center;
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px solid #333;
            font-size: 10px;
        }
        .qr-code {
            text-align: center;
            margin: 10px 0;
        }
        @media print {
            body { margin: 0; padding: 0; }
            .ticket { border: none; box-shadow: none; }
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="header">
            <div class="company-name">{{COMPANY_NAME}}</div>
            <div class="title">WIFI HOTSPOT TICKET</div>
        </div>
        
        <div class="user-info">
            <div class="info-row">
                <span class="label">Name:</span>
                <span>{{USER_NAME}}</span>
            </div>
            <div class="info-row">
                <span class="label">Profile:</span>
                <span>{{USER_PROFILE}}</span>
            </div>
            <div class="info-row">
                <span class="label">Created:</span>
                <span>{{CREATED_DATE}}</span>
            </div>
            <div class="info-row">
                <span class="label">Limit:</span>
                <span>{{LIMIT_BYTES}}</span>
            </div>
            <div class="info-row">
                <span class="label">Uptime:</span>
                <span>{{LIMIT_UPTIME}}</span>
            </div>
        </div>
        
        <div class="credentials">
            <div class="username">Username: {{USERNAME}}</div>
            <div class="password">Password: {{PASSWORD}}</div>
        </div>
        
        <div class="footer">
            <div>Thank you for using our service</div>
            <div>Support: {{COMPANY_PHONE}}</div>
            <div>Website: {{COMPANY_WEBSITE}}</div>
        </div>
    </div>
    
    <script>
        // Auto print when page loads
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>',
    1
  );

-- Available template variables:
-- {{COMPANY_NAME}} - Company/ISP name
-- {{COMPANY_PHONE}} - Company phone number  
-- {{COMPANY_WEBSITE}} - Company website
-- {{USER_NAME}} - Hotspot user name
-- {{USERNAME}} - Login username (same as user name)
-- {{PASSWORD}} - Login password  
-- {{USER_PROFILE}} - User profile/package
-- {{CREATED_DATE}} - Date user was created
-- {{LIMIT_BYTES}} - Data limit in readable format
-- {{LIMIT_UPTIME}} - Time limit
-- {{SERVER_NAME}} - Hotspot server name
-- {{COMMENT}} - User comment/notes